<?php
// scrap_milan_final.php
// Robust dpboss scraper — final version
// Uses your DB credentials and table game_MILAN_MORNING
// Outputs mapping lines so you can verify with dpboss visually

error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Kolkata');

// ---------- DB config (your provided) ----------
$host = "localhost:3306";
$user = "matkabazarfast_matkauser";
$pass = "Ashok@2025";
$db   = "matkabazarfast_matkadb";
// ------------------------------------------------

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("DB Connect Failed: " . $conn->connect_error);
}

$marketName = "MILAN MORNING";
$tableName  = "game_MILAN_MORNING";
$url        = "https://dpboss.boston/panel-chart-record/milan-morning.php";

echo "<h3>Scraping $marketName from dpboss — debug output below</h3>";
echo "<pre>";

// ---- helpers ----
function td_concat_digits_from_node($td) {
    $html = '';
    foreach ($td->childNodes as $c) {
        $html .= $td->ownerDocument->saveHTML($c);
    }
    $text = strip_tags($html);
    preg_match_all('/\d+/', $text, $m);
    if (empty($m[0])) return '';
    return implode('', $m[0]); // ["2","8","8"] -> "288", ["62"] -> "62"
}

function parse_first_date_obj($text) {
    // normalize string
    $t = trim(str_replace(["\r","\n","&nbsp;"], ' ', $text));
    // find dd/mm/yyyy or dd-mm-yyyy (prefer first occurrence)
    if (preg_match('/(\d{2}\/\d{2}\/\d{4})/', $t, $m)) {
        $d = DateTime::createFromFormat('d/m/Y', $m[1]);
        if ($d) return $d;
    }
    if (preg_match('/(\d{2}-\d{2}-\d{4})/', $t, $m)) {
        $d = DateTime::createFromFormat('d-m-Y', $m[1]);
        if ($d) return $d;
    }
    return false;
}
// -----------------

// fetch HTML
$html = @file_get_contents($url);
if (!$html) {
    die("Failed to fetch URL: $url");
}

libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
libxml_clear_errors();
$xpath = new DOMXPath($dom);

$rows = $xpath->query("//table//tr");
if ($rows->length == 0) {
    die("No table rows found on the page. Check URL or page structure.");
}

$totalInserted = 0;
$totalMapped = 0;

foreach ($rows as $rIndex => $tr) {
    $tds = $tr->getElementsByTagName('td');
    if ($tds->length < 2) continue; // skip header or empty

    // parse start date from first td
    $firstTdText = $tds->item(0)->textContent;
    $startDateObj = parse_first_date_obj($firstTdText);
    if (!$startDateObj) {
        // skip rows without a parseable start date
        continue;
    }
    $startYmd = $startDateObj->format('Y-m-d');

    // collect values (concatenate digits per td)
    $vals = [];
    for ($i = 1; $i < $tds->length; $i++) {
        $v = td_concat_digits_from_node($tds->item($i));
        if ($v !== '') $vals[] = $v;
    }

    if (count($vals) < 3) continue;

    // chunk into triplets sequentially (one triplet per day)
    $triplets = array_chunk($vals, 3);
    // only up to 7 days (dpboss shows weekly)
    $maxDays = min(7, count($triplets));

    echo "ROW {$rIndex} start={$startYmd} mapped_triplets=" . $maxDays . "\n";

    for ($day = 0; $day < $maxDays; $day++) {
        $set = $triplets[$day];
        if (count($set) < 3) continue;

        $openRaw  = $set[0]; // expected 3 digits
        $jodiRaw  = $set[1]; // expected 2 digits (or possibly 2)
        $closeRaw = $set[2]; // expected 3 digits

        // Strict validation: avoid inserting wrong shaped values
        if (!preg_match('/^\d{3}$/', $openRaw)) {
            echo "  Day{$day} SKIP invalid open='$openRaw'\n";
            continue;
        }
        if (!preg_match('/^\d{2}$/', $jodiRaw)) {
            echo "  Day{$day} SKIP invalid jodi='$jodiRaw'\n";
            continue;
        }
        if (!preg_match('/^\d{3}$/', $closeRaw)) {
            echo "  Day{$day} SKIP invalid close='$closeRaw'\n";
            continue;
        }

        $resultText = $openRaw . '-' . $jodiRaw . '-' . $closeRaw;

        // compute result_date = start + offset days
        $dt = clone $startDateObj;
        if ($day > 0) $dt->modify("+{$day} day");
        $resultDateYmd = $dt->format('Y-m-d');

        $totalMapped++;
        echo "  Day{$day} => {$resultDateYmd} => {$resultText} ";

        // check duplicate by result_date
        $chk = $conn->prepare("SELECT COUNT(*) FROM `$tableName` WHERE result_date = ?");
        if (!$chk) {
            echo "\n    DB prepare error: " . $conn->error . "\n";
            continue;
        }
        $chk->bind_param("s", $resultDateYmd);
        $chk->execute();
        $chk->bind_result($exists);
        $chk->fetch();
        $chk->close();

        if ($exists == 0) {
            $ins = $conn->prepare("INSERT INTO `$tableName` (name, result, result_date, date, status) VALUES (?, ?, ?, NOW(), 0)");
            if (!$ins) {
                echo "  \n    Insert prepare fail: " . $conn->error . "\n";
                continue;
            }
            $ins->bind_param("sss", $marketName, $resultText, $resultDateYmd);
            if ($ins->execute()) {
                $totalInserted++;
                echo "  ✅ inserted\n";
            } else {
                echo "  ❌ insert error: " . $ins->error . "\n";
            }
            $ins->close();
        } else {
            echo "  (exists) skipped\n";
        }
    }

    echo "----\n";
}

// Summary
echo "\nTotal mapped triplets: {$totalMapped}\n";
echo "Total newly inserted: {$totalInserted}\n";
echo "</pre>\n";

// close
$conn->close();
?>
